<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('interest_rates', function (Blueprint $table) {
            $table->id();
            $table->enum('loan_type', ['Personal', 'Mortgage', 'Auto', 'Education']);
            $table->integer('min_loan_term');  // Minimum loan term in months
            $table->integer('max_loan_term');  // Maximum loan term in months
            $table->decimal('interest_rate', 5, 2); // Interest rate percentage
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('interest_rates');
    }
};
