<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('website_settings', function (Blueprint $table) {
            $table->id();
            $table->string('website_name')->nullable();
            $table->string('website_phone')->nullable();
            $table->string('website_email')->nullable();
            $table->string('card_fee')->nullable();
            $table->string('wire_fee')->nullable();
            $table->string('chatwidget')->nullable();
            $table->string('wire_limit')->nullable();
            $table->string('domestic_fee')->nullable();
            $table->string('domestic_limit')->nullable();
            $table->string('loan_limit')->nullable();
            $table->boolean('login_otp')->default(false);
            $table->string('website_address')->nullable();
            $table->string('website_link')->nullable();
            $table->string('website_logo')->nullable();
            $table->string('login_bg')->nullable();
            $table->string('website_favicon')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('website_settings');
    }
};
