<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transfer_codes', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Store code name: COT, IMF, Tax
            $table->string('code')->nullable(); // Code value
            $table->boolean('is_enabled')->default(false); // Whether the code is enabled
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transfer_codes');
    }
};
