<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('local_transfers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('beneficiary_name');
            $table->string('beneficiary_bank_name');
            $table->string('beneficiary_account_number');
            $table->enum('beneficiary_account_type', ['Savings Account', 'Current Account', 'Retirement Account', 'Money Market Account (MMAs)', 'Checking Account', 'Domiciliary Account', 'Online Banking']);
            $table->decimal('amount', 15, 2);
            $table->text('description')->nullable();
            $table->string('transaction_reference')->unique();
            $table->enum('status', ['Pending', 'Processing', 'Completed', 'Failed']);
            $table->timestamp('initiated_at');
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('local_transfers');
    }
};
