<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('kyc_documents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            // Proof of Identity
            $table->enum('identity_document_type', [
                'Passport', 
                'Drivers License', 
                'National ID Card', 
                'Voter ID Card', 
                'PAN Card', 
                'Employee ID Card'
            ]); // Enum for proof of identity types
            $table->string('identity_document_number'); // Number of the proof of identity document
            $table->string('frontphoto')->nullable(); // Photo of the proof of identity document
            $table->string('backphoto')->nullable(); // Photo of the proof of identity document

            // Employment Status
            $table->string('employment_status'); // Employment status of the customer
            
            // KYC Status
            $table->enum('status', ['Pending', 'Approved', 'Rejected']); // Status of KYC
            
            $table->timestamp('submitted_at'); // Timestamp for when documents are submitted
            $table->timestamp('verified_at')->nullable(); // Timestamp for when documents are verified
            
            $table->timestamps(); // Created and updated timestamps
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('kyc_documents');
    }
};
