<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cards', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('card_number')->unique();
            $table->enum('card_type', ['Debit', 'Credit']);
            $table->enum('card_brand', ['Visa', 'Mastercard', 'American Express', 'Discover']);
            $table->date('expiry_date');
            $table->string('cvv');
            $table->string('card_pin');
            $table->enum('card_status', ['Pending', 'Active', 'Blocked', 'Expired']);
            $table->date('issued_date');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cards');
    }
};
