<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->enum('transaction_type', ['Debit', 'Wire Transfer', 'Check Deposit', 'Credit', 'Domestic Transfer']);
            $table->decimal('amount', 15, 2);
            $table->string('bank_name')->nullable();
            $table->string('account_name')->nullable();
            $table->string('account_number')->nullable();
            $table->string('country')->nullable();
            $table->string('routing')->nullable();
            $table->timestamp('transaction_date');
            $table->text('description')->nullable();
            $table->enum('status', ['Pending', 'Processing', 'Completed', 'Failed']);
            $table->uuid('reference')->unique();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
