<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('firstname', 200)->nullable();
            $table->string('lastname', 200)->nullable();
            $table->string('username')->nullable();
            $table->string('account_no', 255)->nullable();
            $table->enum('account_type', ['Savings Account', 'Current Account', 'Retirement Account', 'Money Market Account (MMAs)', 'Checking Account', 'Domiciliary Account', 'Online Banking']);
            $table->string('acct_currency')->nullable();
            $table->decimal('account_balance', 15, 2)->default(0);
            $table->decimal('account_limit', 15, 2)->default(0);
            $table->decimal('loan_balance', 15, 2)->default(0);
            
            // KYC and Verification Fields
            $table->integer('phoneverify')->default(1)->comment('1 = verified, 0 = unverified');

            $table->string('email')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->string('photo')->nullable();
            $table->string('phone')->default('user.png');
            $table->string('gender')->nullable();
            $table->string('dob')->nullable();
            $table->string('country')->nullable();
            $table->string('state')->nullable();
            $table->string('city')->nullable();
            $table->string('address')->nullable();
            $table->string('acct_ssn')->nullable();
            $table->enum('role', ['admin', 'user'])->default('user');
            $table->enum('acct_status',['Active', 'Inactive', 'Suspended'])->default('Active');
            $table->enum('acct_level',['Primary', 'Plus', 'Premium', 'Pinnacle'])->default('Primary');
            $table->enum('kyc_status', ['Pending', 'Approved', 'Rejected'])->default('Pending');
            // Security Information
            $table->string('acct_pin', 6)->default('123456');
            $table->string('acct_otp', 6)->default('123456');
            $table->boolean('otp_enabled')->default(false); // Default is deactivated
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
