<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class UserFactory extends Factory
{
    /**
     * The current password being used by the factory.
     */
    protected static ?string $password;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'firstname' => $this->faker->firstName,
            'lastname' => $this->faker->lastName,
            'username' => $this->faker->username,
            'account_no' => $this->faker->unique()->bankAccountNumber,
            'acct_currency' => $this->faker->currencyCode,
            'loan_balance' => $this->faker->randomFloat(2, 0, 10000),
            'account_balance' => $this->faker->randomFloat(2, 0, 10000),
            'account_limit' => $this->faker->randomFloat(2, 0, 10000),
            'account_type' => $this->faker->randomElement(['Savings Account', 'Current Account', 'Retirement Account', 'Money Market Account (MMAs)', 'Checking Account', 'Domiciliary Account', 'Online Banking']),
            'acct_status' => $this->faker->randomElement(['Active', 'Inactive', 'Suspended']),
            'acct_level' => $this->faker->randomElement(['Primary', 'Plus', 'Premium', 'Pinnacle']),
            'phoneverify' => $this->faker->randomElement([1, 0]),
            'email' => fake()->unique()->safeEmail(),
            'email_verified_at' => now(),
            'password' => Hash::make('12345678'),  // or Hash::make('password')
            'photo' => 'user.png',
            'phone' => $this->faker->phoneNumber,
            'gender' => $this->faker->randomElement(['male', 'female', 'other']),
            'dob' => $this->faker->date(),
            'country' => $this->faker->country,
            'state' => $this->faker->state,
            'city' => $this->faker->city,
            'address' => $this->faker->address,
            'acct_ssn' => $this->faker->ssn,
            'role' => $this->faker->randomElement(['admin', 'user']),
            'kyc_status' => $this->faker->randomElement(['Pending', 'Approved', 'Rejected']),
            'acct_pin' => '123456',  // or generate a random pin: $this->faker->numerify('######')
            'acct_otp' => '123456',  // or generate a random OTP: $this->faker->numerify('######'),
        ];
    }

    /**
     * Indicate that the model's email address should be unverified.
     */
    public function unverified(): static
    {
        return $this->state(fn (array $attributes) => [
            'email_verified_at' => null,
        ]);
    }
}
