<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use App\Http\Middleware\Role;
use App\Http\Middleware\CheckUserStatus;
use App\Http\Middleware\KycCheck;
use App\Http\Middleware\PreventBackHistory; // Include the middleware
use App\Http\Middleware\RedirectIfAuthenticated;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'role' => Role::class,
            'checkstatus' => CheckUserStatus::class,
            'guest' => RedirectIfAuthenticated::class,
            'preventBackHistory' => PreventBackHistory::class, // Register with an alias
            'admin' => \App\Http\Middleware\AdminMiddleware::class,
            'access.code' => \App\Http\Middleware\AccessCodeMiddleware::class,

        ]);
        })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
