<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;

class PadiwiseSmsService
{
    protected $apiUrl;
    protected $token;
    protected $sender;
    protected $pin;

    public function __construct()
    {
        $this->apiUrl = env('PADIWISE_SMS_URL');
        $this->token = env('PADIWISE_SMS_TOKEN');
        $this->sender = env('PADIWISE_SMS_SENDER');
        $this->pin = env('PADIWISE_TRANSACTION_PIN');
    }

    public function send($recipient, $message)
    {
        // Generate a unique reference for this request
        $reference = 'sms-' . uniqid();

        $response = Http::withHeaders([
            'Accept' => 'application/json',
            'Authorization' => 'Bearer ' . $this->token,
        ])->post($this->apiUrl, [
            'recipient' => $recipient,
            'message' => $message,
            'sender_name' => $this->sender,
            'transaction_pin' => $this->pin,
            'reference' => $reference,
        ]);

        return $response->successful()
            ? ['status' => 'success', 'response' => $response->json()]
            : ['status' => 'error', 'message' => $response->body()];
    }
}