<?php

namespace App\Providers;

use App\Models\SmtpSetting;
use App\Services\PadiwiseSmsService;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(PadiwiseSmsService::class, function ($app) {
            return new PadiwiseSmsService();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Paginator::useBootstrap();

        $smtp = SmtpSetting::first();
        
        if ($smtp) {
            $data = [
                'driver' => $smtp->mail_mailer,
                'host' => $smtp->mail_host,
                'port' => $smtp->mail_port,
                'encryption' => $smtp->mail_host,
                'username' => $smtp->mail_username,
                'password' => $smtp->mail_password,
                'from' => [
                    'address'  => $smtp->mail_from_address,
                    'name'     => $smtp->mail_from_name
                ]
            ];

            $AppName = [
                'name' => $smtp->app_name
            ];

            Config::set('app.name', $AppName['name']);
            Config::set('mail', $data);
        }
    }
}
