<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserSession extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'device', 'ip_address', 'browser', 'platform', 'country'
    ];

    // Relationship: Each session belongs to one user
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
