<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'firstname',
        'lastname',
        'username',
        'email',
        'password',
        'photo',
        'account_balance',
        'account_currency',
        'phone',
        'gender',
        'dob',
        'country',
        'state',
        'city',
        'address',
        'account_limit',
        'loan_balance',
        'otp_enabled',
        'acct_status',
        'acct_ssn',
        'account_type',
        'account_no',
        'acct_pin',
        'acct_otp',
        'acct_level',
        'role',
        'last_login_country',
        'last_login_at'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    // Relationship with UserSession
    public function sessions()
    {
        return $this->hasMany(UserSession::class);
    }

    public function nextOfKin()
    {
        return $this->hasOne(NextOfKin::class);
    }

    public function localTransfers()
    {
        return $this->hasMany(LocalTransfer::class);
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }

    public function wiretransfer()
    {
        return $this->hasMany(WireTransfer::class);
    }

    public function cards()
    {
        return $this->hasMany(Cards::class);
    }

    public function loans()
    {
        return $this->hasMany(Loans::class);
    }

    // Relationship with CheckDeposit (for both admin and users)
    public function checkDeposits()
    {
        return $this->hasMany(CheckDeposit::class);
    }

    // Only for admin: Approved check deposits
    public function approvedCheckDeposits()
    {
        return $this->hasMany(CheckDeposit::class, 'approved_by');
    }

    public function kycDocuments()
    {
        return $this->hasMany(KycDocuments::class, 'user_id');
    }

    // Check if the user is an admin (based on id = 1)
    public function isAdmin()
    {
        return $this->id === 1;
    }
}
