<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LocalTransfer extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'beneficiary_name',
        'beneficiary_bank_name',
        'beneficiary_account_number',
        'beneficiary_account_type',
        'amount',
        'description',
        'transaction_reference',
        'status',
        'initiated_at',
        'completed_at',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
