<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CheckDeposit extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'check_number',
        'amount',
        'bank_name',
        'check_image',
        'status',
        'approved_at',
        'approved_by',
    ];

    // The user who submitted the check deposit
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    // The admin who approved/rejected the check deposit
    public function approvedBy()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }
}
