<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cards extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'card_number',
        'card_type',
        'card_brand',
        'expiry_date',
        'cvv',
        'card_pin',
        'card_status',
        'issued_date',
        'balance',
    ];


    /**
     * Get the user that owns the card.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    

    public function transactions()
    {
        return $this->hasMany(CardTransactionHistory::class);
    }
}
