<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\WireTransfer;

class WireTransferNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $wireTransfer;

    public function __construct(WireTransfer $wireTransfer)
    {
        $this->wireTransfer = $wireTransfer;
    }

    public function build()
    {
        return $this->subject('Wire Transfer Initiated')
                    ->view('emails.wire_transfer')
                    ->with([
                        'amount' => $this->wireTransfer->amount,
                        'beneficiary_name' => $this->wireTransfer->beneficiary_name,
                        'bank_name' => $this->wireTransfer->beneficiary_bank_name,
                        'status' => $this->wireTransfer->status,
                        'reference' => $this->wireTransfer->transaction_reference,
                    ]);
    }
}
