<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class NewUserWelcomeMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;

    /**
     * Create a new message instance.
     */
    public function __construct($user) 
    { 
        $this->user = $user; 
    }

    public function build() 
    { 
        return $this->view('emails.new_user_welcome') 
        ->subject('Welcome') 
        ->with([ 
            'first_name' => $this->user->firstname, 
            'last_name' => $this->user->lastname, 
            'account_number' => $this->user->account_no, 
            'acct_pin' => $this->user->acct_pin, 
            'acct_otp' => $this->user->acct_otp, 
            'account_level' => $this->user->acct_level, 
            'account_balance' => $this->user->account_balance, 
            'account_type' => $this->user->account_type, ]); 
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'New Customer Welcome Mail',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.new_user_welcome',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
