<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class DomesticTransferNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $localTransfer; // Public property to pass data to the view

    /**
     * Create a new message instance.
     */
    public function __construct($localTransfer)
    {
        $this->localTransfer = $localTransfer;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this
            ->subject('Domestic Transfer Notification')
            ->view('emails.domestic_notification');
    }
}
