<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class CardApplicationNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $card; // Public property to pass card details to the view

    /**
     * Create a new message instance.
     */
    public function __construct($card)
    {
        $this->card = $card;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this
            ->subject('Card Application Submitted')
            ->view('emails.card_application');
    }
}
