<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle($request, Closure $next)
    {
        if (Auth::check()) {
            $user = Auth::user();
        
            // Redirect based on role
            if ($user->role === 'admin') {
                return redirect()->route('admin.dashboard'); // Admin Dashboard
            }
        
            if ($user->role === 'user') {
                return redirect()->route('account.dashboard'); // User Dashboard
            }
        }
        
        return $next($request);
    }
}
