<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CheckUserStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle($request, Closure $next) 
    { 
        $user = Auth::user(); 
        if ($user) { if ($user->acct_status === 'Location') { 
            Auth::logout(); 
            return redirect('/login')->with('warning', 'We detected an Unusual Activity on your account. Your account was logged in from an Unknown Location. Please visit any of our nearest branch for verification.'); 
        } elseif ($user->acct_status === 'Suspended') { 
            Auth::logout(); 
            return redirect('/login')->with('warning', 'Your account is on Hold. Please visit any of our nearest branch for verification.');  
        } } return $next($request);
    }


    }
