<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AccessCodeMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        // First check if ACCESS_CODE_ONLY is enabled in .env
        if (env('ACCESS_CODE_ONLY', false)) {
            // Check if the current route is the access code form (to avoid infinite redirect)
            if ($request->routeIs('access-code.form')) {
                return $next($request);
            }
            
            // Check if access code is provided in the request (either GET or POST)
            $accessCode = $request->input('access_code') ?? $request->query('access_code');
            
            if (!$accessCode) {
                return redirect()->route('access-code.form');
            }
            
            // Validate the access code
            $userExists = DB::table('website_settings')->where('reg_access', $accessCode)->exists();
            
            if (!$userExists) {
                return redirect()->route('access-code.form')->withErrors(['code' => 'Invalid access code.']);
            }
        }

        return $next($request);
    }
}