<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\WebsiteSettings;
use App\Models\TransferCode;
use App\Models\SmtpSetting;
use Illuminate\Support\Str;
use File;

class WebsiteSettingsController extends Controller
{
    public function adminsettings(Request $request)
    {
        // Retrieve COT, IMF, and Tax codes from the database
        $data['transferCodes'] = TransferCode::whereIn('name', ['COT Code', 'IMF Code', 'Tax Code'])->get();
        $data['website'] = WebsiteSettings::find(1);
        $data['settings'] = SmtpSetting::first();
        return view('admin.settings', $data);
    }
    
    
    public function adminsettingstore(Request $request)
    {
      //  dd($request->all());

        $save = WebsiteSettings::find(1);
            $save->website_name     = trim($request->website_name);
            $save->website_phone    = trim($request->website_phone);
            $save->website_email    = trim($request->website_email);
            $save->chatwidget    = trim($request->chatwidget);
            $save->website_address  = trim($request->website_address);
            $save->website_link  = trim($request->website_link);
            $save->card_fee  = trim($request->card_fee);
            $save->wire_fee  = trim($request->wire_fee);
            $save->wire_limit  = trim($request->wire_limit);
            $save->domestic_fee  = trim($request->domestic_fee);
            $save->domestic_limit  = trim($request->domestic_limit);
            $save->loan_limit  = trim($request->loan_limit);
            $save->login_otp  = trim($request->login_otp);

            if(!empty($request->file('website_logo'))){
                    
                $file = $request->file('website_logo');
                $randomStr = Str::random(30);
                $filename = $randomStr .'.'.$file->getClientOriginalExtension();
                $file->move('upload/', $filename);
                $save->website_logo = $filename;
            }

            if(!empty($request->file('website_favicon'))){
                    
                $file = $request->file('website_favicon');
                $randomStr = Str::random(30);
                $filename = $randomStr .'.'.$file->getClientOriginalExtension();
                $file->move('upload/', $filename);
                $save->website_favicon = $filename;
            }
            
            if(!empty($request->file('login_bg'))){
                    
                $file = $request->file('login_bg');
                $randomStr = Str::random(30);
                $filename = $randomStr .'.'.$file->getClientOriginalExtension();
                $file->move('upload/', $filename);
                $save->login_bg = $filename;
            }

            $save->save();

            return redirect()->route('admin.settings', ['tab' => 'home'])->with('message', 'Website settings updated.');
    }

    public function updateTransferCode(Request $request)
    {

        foreach ($request->codes as $id => $code) {
            $transferCode = TransferCode::findOrFail($id);
            $transferCode->code = $code;
            $transferCode->is_enabled = isset($request->enabled[$id]) ? true : false;
            $transferCode->save();
        }

        return redirect()->route('admin.settings', ['tab' => 'profile'])->with('message', 'Billing codes updated.');
    }
}
