<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Loans;
use App\Models\Country;
use App\Models\UkBanks;
use App\Models\UsBanks;
use App\Models\Currency;
use App\Models\Transaction;
use App\Models\UserSession;
use App\Models\Notification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Stevebauman\Location\Facades\Location;


class UserController extends Controller
{
    public function index()
    {
        $users = User::paginate();

        return view('users.index', compact('users'));
    }

    public function account_dashboard(Transaction $id)
    {
        $user = Auth::user(); // Get the authenticated user

        // Get the count of pending transactions for the user
        $pendingtransactions = Transaction::where('user_id', $user->id)
            ->where('status', 'Pending')
            ->count();

        // Get the total amount of pending transactions for the user
        $pendingamount = Transaction::where('user_id', $user->id)
            ->where('status', 'Pending')
            ->sum('amount');

        $totalDebit = Transaction::where('user_id', $user->id)
            ->where('transaction_type', 'Debit')
            ->sum('amount');

        $totalCredit = Transaction::where('user_id', $user->id)
            ->where('transaction_type', 'Credit')
            ->sum('amount');

        $transactions = Transaction::where('user_id', auth()->id())
            ->orderBy('created_at', 'desc')
            ->take(6)
            ->get();

        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
            ->where('is_read', false)  // Filter by unread notifications
            ->orderBy('created_at', 'desc')
            ->get();

        return view('account.dashboard', compact('transactions', 'pendingtransactions', 'totalDebit', 'totalCredit', 'pendingamount', 'notifications'));
    }

    public function account_profile()
    {
        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
            ->where('is_read', false)  // Filter by unread notifications
            ->orderBy('created_at', 'desc')
            ->get();

        $user = Auth::user();
        $nextOfKin = $user->nextOfKin;

        return view('account.profile', compact('notifications', 'user', 'nextOfKin'));
    }


    public function profiledetails()
    {
        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
            ->where('is_read', false)  // Filter by unread notifications
            ->orderBy('created_at', 'desc')
            ->get();
        return view('account.profile_details', compact('notifications'));
    }


    public function profilesecurity()
    {
        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
            ->where('is_read', false)  // Filter by unread notifications
            ->orderBy('created_at', 'desc')
            ->get();
        return view('account.security', compact('notifications'));
    }

    public function profilesecuritystore(Request $request)
    {
        $user = Auth::user();

        $user->password = Hash::make($request->password);

        $user->save();

        return redirect()->back()->with('message', 'Password updated successfully.');
    }

    public function profileloginpin()
    {
        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
            ->where('is_read', false)  // Filter by unread notifications
            ->orderBy('created_at', 'desc')
            ->get();
        return view('account.pin', compact('notifications'));
    }

    public function toggleOtp(Request $request)
    {
        $user = Auth::user();

        // Validate input fields
        $request->validate([
            'acct_otp' => 'required|string|max:255',
            'acct_pin' => 'required|string|max:255',
        ]);

        // Toggle the OTP setting
        $user->otp_enabled = !$user->otp_enabled; // Toggle the OTP status
        $user->acct_pin = $request->acct_pin;
        $user->acct_otp = $request->acct_otp;
        $user->save();

        return redirect()->back()->with('message', 'Account PIN updated successfully.');
    }




    public function account_deposit()
    {
        // Fetch banks from both usbanks and ukbanks tables
        $usbanks = DB::table('us_banks')->select('id', 'name')->get();
        $ukbanks = DB::table('uk_banks')->select('id', 'name')->get();

        // Combine the two collections
        $banks = $usbanks->merge($ukbanks);

        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
            ->where('is_read', false)  // Filter by unread notifications
            ->orderBy('created_at', 'desc')
            ->get();
        return view('account.deposit', compact('banks', 'notifications'));
    }

    public function account_loan()
    {
        $loans = Loans::where('user_id', Auth::id())
            ->where('status', 'Approved')
            ->get();

        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
            ->where('is_read', false)  // Filter by unread notifications
            ->orderBy('created_at', 'desc')
            ->get();

        return view('account.loan', compact('loans', 'notifications'));
    }


    public function accountactivity(Request $request)
    {
        $user = Auth::user();
        $sessions = UserSession::where('user_id', $user->id)->latest()->take(10)->get();

        // Get the real user IP
        $ip = request()->ip();

        // Get location data from IP
        $location = Location::get($ip);

        // Fetch ISP & Network details from ip-api.com
        $ipApiUrl = "http://ip-api.com/json/{$ip}?fields=status,country,regionName,city,lat,lon,isp,org,as,query";
        $ipData = json_decode(file_get_contents($ipApiUrl));

        // Assign country if found, otherwise set to 'Unknown'
        $country = $location ? $location->countryName : 'Unknown';

        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
            ->where('is_read', false)  // Filter by unread notifications
            ->orderBy('created_at', 'desc')
            ->get();
        return view('account.activity', compact('user', 'sessions', 'location', 'notifications', 'country', 'ipData'));
    }


    public function accountchatbot(Request $request)
    {
        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
            ->where('is_read', false)  // Filter by unread notifications
            ->orderBy('created_at', 'desc')
            ->get();
        return view('account/chat', compact('notifications'));
    }
    
}
