<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\UkBanks;
use App\Models\UsBanks;
use App\Models\Currency;
use App\Models\Transaction;
use Illuminate\Support\Str;
use App\Models\Notification;
use App\Models\WireTransfer;
use Illuminate\Http\Request;
use App\Models\LocalTransfer;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Barryvdh\DomPDF\Facade\Pdf; // Ensure you have Barryvdh DomPDF installed


class TransactionController extends Controller
{

    public function show($id)
    {
        // Fetch the transaction details
        $transaction = Transaction::find($id);

        // Check if transaction exists
        if (!$transaction) {
            return response()->json(['error' => 'Transaction not found'], 404);
        }

        return response()->json($transaction);
    }

    public function admintranslist(Request $request)
    {
        $data['getRecord'] = Transaction::latest()->paginate(10)->appends(request()->query());
        return view('admin.transactions.list', $data);
    }

    public function admintransupdate(Request $request, $id)
    {
        $data['currency'] = Currency::all();
        $data['transaction'] = Transaction::find($id);
        return view('admin.transactions.update', $data);
    }


    public function admintranshistory(Request $request)
    {
        // Fetch banks from both usbanks and ukbanks tables
        $usbanks = DB::table('us_banks')->select('id', 'name')->get();
        $ukbanks = DB::table('uk_banks')->select('id', 'name')->get();

        // Combine the two collections
        $banks = $usbanks->merge($ukbanks);

        $data['user'] = User::where('role', 'user')->get();
        $data['currency'] = Currency::all();
        return view('admin.transactions.history', $data, compact('banks'));
    }

    public function admintranshistoryadd(Request $request)
    {
        // Fetch the domestic transfer fee from website_settings
        $transFee = DB::table('website_settings')->value('domestic_fee');
        $transFee = $transFee ? (float) $transFee : 0;

        // Create a new transaction
        $transaction = new Transaction;
        $transaction->user_id = trim($request->user_id);
        $transaction->amount = trim($request->amount);
        $transaction->bank_name = trim($request->bank_name);
        $transaction->account_name = trim($request->account_name);
        $transaction->account_number = trim($request->account_number);
        $transaction->currency = trim($request->currency);
        $transaction->fee = $transFee;
        $transaction->status = trim($request->status);
        $transaction->transaction_type = trim($request->transaction_type);
        $transaction->description = trim($request->description);

        // Parse the transaction_date
        $transactionDate = $request->filled('transaction_date')
            ? Carbon::parse($request->transaction_date)
            : now();

        $transaction->transaction_date = $transactionDate;
        $transaction->created_at = $transactionDate; // use same date for created_at
        $transaction->reference = str_pad(mt_rand(0, 999999999999), 15, '0', STR_PAD_LEFT);

        $transaction->save();

        return redirect('admin/transactions/list')->with('message', 'Transaction history added successfully.');
    }

    public function admintransupdatestore(Request $request, $id)
    {
        //     dd($request->all());

        $save = Transaction::find($id);
        $save->amount = trim($request->amount);
        $save->status    = trim($request->status);
        $save->currency = trim($request->currency);
        $save->transaction_type    = trim($request->transaction_type);
        $save->description    = trim($request->description);
        $save->transaction_date    = trim($request->transaction_date);

        // Parse the transaction_date
        $transactionDate = $request->filled('transaction_date')
            ? Carbon::parse($request->transaction_date)
            : now();

        $save->transaction_date = $transactionDate;
        $save->created_at = $transactionDate;
        $save->save();

        return redirect('admin/transactions/list')->with('message', 'Transaction Updated successfully.');
    }

    public function adminaddbal(User $id)
    {
        $data['user'] = User::where('role', 'user')->get();
        return view('admin.transactions.add', $data);
    }


    public function adminaddbalstore(Request $request, User $id)
    {
        //    dd($request->all());
        // Validate the input
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'amount' => 'required|numeric',
            'operation' => 'required|in:add,subtract',
        ]);

        // Find the user
        $user = User::find($request->user_id);

        // Get the current balance
        $currentBalance = $user->account_balance; // Assuming the balance column is `default_balance`

        // Update the balance based on the operation
        if ($request->operation == 'add') {
            $user->account_balance = $currentBalance + $request->amount;
        } else if ($request->operation == 'subtract') {
            $user->account_balance = $currentBalance - $request->amount;
        }

        // Save the updated balance
        $user->save();

        // Redirect or show success message
        return redirect()->back()->with('message', 'Balance updated successfully.');
    }


    public function admindedbal(Request $request)
    {
        return view('admin.transactions.deduct');
    }



    public function account_transaction(Request $request)
    {
        $user = Auth::user(); // Get the authenticated user

        // Get authenticated user's transactions and sort by recent ID on top
        $transactions = Transaction::where('user_id', auth()->id())
            ->orderBy('id', 'desc')
            ->get();

        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
            ->where('is_read', false)  // Filter by unread notifications
            ->orderBy('created_at', 'desc')
            ->get();
        return view('account.transactions', compact('transactions', 'notifications'));
    }

    public function accountwiretransaction(Request $request)
    {
        $user = Auth::user();

        // Fetch wire transfers from transactions table where transaction_type is 'Wire Transfer'
        $transfer = Transaction::where('user_id', $user->id)
            ->where('transaction_type', 'Wire Transfer')
            ->orderBy('id', 'desc')
            ->get();

        // Fetch unread notifications
        $notifications = Notification::where('user_id', $user->id)
            ->where('is_read', false)
            ->orderBy('created_at', 'desc')
            ->get();

        return view('account.wire_transactions', compact('transfer', 'notifications'));
    }


    public function viewReceipt($id)
    {
        // Fetch the transfer details
        $transfer = Transaction::findOrFail($id);

        // Format the transfer date to '26 Nov 2024 06:45 PM'
        $transfer->formatted_date = Carbon::parse($transfer->initiated_at)->format('d M Y h:i A');

        // Generate the PDF using a Blade template
        $pdf = Pdf::loadView('account/transaction_receipt', compact('transfer'));

        // Return the PDF as a download
        return $pdf->download('transaction_receipt_' . $transfer->id . '.pdf');
    }


    public function admintransactiondestroy(Request $request, $id)
    {

        $transaction = Transaction::findOrFail($id);
        $transaction->delete();
        return redirect('admin/transactions/list')->with('message', 'Transaction deleted successfully!');
    }
}
