<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SmtpSetting;

class SmtpSettingController extends Controller
{
    public function updateSmtpSettings(Request $request) 
    {

      //  dd($request->all());
            
        $validated = $request->validate([
            'mail_host' => 'required',
            'mail_port' => 'required',
            'mail_username' => 'required',
            'mail_password' => 'required',
            'mail_from_address' => 'required|email',
            'mail_from_name' => 'required',
            'mail_encryption' => 'required',
        ]);

        SmtpSetting::updateOrCreate(['id' => 1], $validated);

        return redirect()->route('admin.settings', ['tab' => 'contact'])->with('message', 'SMTP settings updated.');
    }
}
