<?php

namespace App\Http\Controllers;

use App\Services\PadiwiseSmsService;
use Illuminate\Http\Request;

class SmsTestController extends Controller
{
    protected $smsService;

    public function __construct(PadiwiseSmsService $smsService)
    {
        $this->smsService = $smsService;
    }

    public function sendsms(Request $request)
    {
        $request->validate([
            'recipient' => 'required|string',
            'message' => 'required|string',
        ]);

        $result = $this->smsService->send($request->recipient, $request->message);

        return response()->json($result);
    }


    public function smsform()
    {
        return view('admin.sms.form');
    }
}