<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Notification;

class NotificationController extends Controller
{
    public function usernotification()
    {
        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
                                    ->where('is_read', false)  // Filter by unread notifications
                                    ->orderBy('created_at', 'desc')
                                    ->get();

        return view('account.notification', compact('notifications'));
    }


    /**
     * Clear all notifications for the authenticated user.
     */
    public function notificationclearAll()
    {
        // Get the authenticated user
        $user = Auth::user();

        // Update all notifications for the authenticated user to be marked as read
        Notification::where('user_id', $user->id)->update(['is_read' => true]);

        // Redirect back with a success message
        return redirect()->back()->with('message', 'All notifications has been cleared successfully.');
    }
}
