<?php

namespace App\Http\Controllers;

use App\Models\NextOfKin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class NextOfKinController extends Controller
{
    // Show Next of Kin form
    public function index()
    {
        $user = Auth::user();
        $nok = $user->nextOfKin;

        return view('user.next-of-kin', compact('nok'));
    }

    // Store or update Next of Kin
    public function storenok(Request $request)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'relationship' => 'required|string|max:100',
            'phone' => 'required|string|max:20',
            'email' => 'nullable|email',
            'address' => 'nullable|string|max:255',
            'dob' => 'nullable|date',
            'ssn' => 'nullable|string|max:20',
            'occupation' => 'nullable|string|max:100',
            'emergency_contact' => 'nullable|string|max:255',
        ]);

        // Check if Next of Kin already exists for this user
        if (NextOfKin::where('user_id', $request->user_id)->exists()) {
            return redirect()->back()->with('warning', 'This user already has a Next of Kin.');
        }

        // Create new Next of Kin
        NextOfKin::create([
            'user_id' => $request->user_id,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'relationship' => $request->relationship,
            'phone' => $request->phone,
            'email' => $request->email,
            'address' => $request->address,
            'dob' => $request->dob,
            'ssn' => $request->ssn,
            'occupation' => $request->occupation,
            'emergency_contact' => $request->emergency_contact,
        ]);

        return redirect('admin/users/next')->with('success', 'Next of kin information saved successfully.');
    }

    public function updatenok(Request $request, $id)
    {
        // Find the Next of Kin record by ID
        $nok = NextOfKin::findOrFail($id);
        $nok->user_id = $request->user_id;
        $nok->first_name = $request->first_name;
        $nok->last_name = $request->last_name;
        $nok->relationship = $request->relationship;
        $nok->phone = $request->phone;
        $nok->email = $request->email;
        $nok->address = $request->address;
        $nok->dob = $request->dob;
        $nok->ssn = $request->ssn;
        $nok->occupation = $request->occupation;
        $nok->emergency_contact = $request->emergency_contact;

        $nok->save();

        return redirect('admin/users/next')->with('message', 'Next of kin updated successfully.');
    }



    // Delete Next of Kin
    public function adminnokdestroy(Request $request, $id) {
    
        $nok = NextOfKin::findOrFail($id);
        $nok->delete();
        return redirect('admin/users/next')->with('message', 'Next Of Kin deleted successfully!');
    }
}
