<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Country;
use App\Models\State;
use App\Models\City;

class LocationController extends Controller
{
    // Fetch all countries
    public function getCountries()
    {
        // Retrieve all countries from the database
        $countries = Country::all();

        // Return as JSON response
        return response()->json($countries);
    }

    // Get states based on country_id
    public function getStates($country_id)
    {
        $states = State::where('country_id', $country_id)->get();
        return response()->json($states);
    }

    // Get cities based on state_id
    public function getCities($state_id)
    {
        $cities = City::where('state_id', $state_id)->get();
        return response()->json($cities);
    }
}
