<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Support\Str;
use App\Models\KycDocuments;
use App\Models\Notification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Http\RedirectResponse;

class KycDocumentsController extends Controller
{
    public function userverification()
    {
        // Retrieve only unread notifications (where is_read is false) for the authenticated user
        $notifications = Notification::where('user_id', Auth::id())
                    ->where('is_read', false)  // Filter by unread notifications
                    ->orderBy('created_at', 'desc')
                    ->get();
        return view('account.verification', compact('notifications'));
    } 


    public function submitKYC(Request $request)
    {
       // dd($request->all());
        // Store the uploaded documents and other details
        $kyc = new KycDocuments();
        $kyc->user_id = auth()->id();
        $kyc->identity_document_type = $request->identity_document_type;
        $kyc->identity_document_number = $request->identity_document_number;
        $kyc->employment_status = $request->employment_status;
        $kyc->status = 'Pending'; // Initial status
        $kyc->submitted_at = now();

        if(!empty($request->file('frontphoto'))){
                        
            $file = $request->file('frontphoto');
            $randomStr = Str::random(30);
            $filename = $randomStr .'.'.$file->getClientOriginalExtension();
            $file->move('upload/', $filename);
            $kyc->frontphoto = $filename;
        }
        
        if(!empty($request->file('backphoto'))){
                        
            $file = $request->file('backphoto');
            $randomStr = Str::random(30);
            $filename = $randomStr .'.'.$file->getClientOriginalExtension();
            $file->move('upload/', $filename);
            $kyc->backphoto = $filename;
        }

        $kyc->save();

        // Update the user's kyc_status to 'Pending'
        $user = User::find(auth()->id());
        $user->kyc_status = 'Pending';
        $user->save();

        return redirect()->back()->with('message', 'KYC documents submitted successfully.');
    }


    public function adminverification()
    {
        $data['kyc'] = KycDocuments::with('user')->get();
        return view('admin.verification', $data);
    }


    public function adminVerifyKYC(Request $request, $id)
    {
        $kyc = KycDocuments::findOrFail($id);
        $request->validate([
            'status' => 'required|in:Approved,Rejected',
        ]);

        $kyc->status = $request->status;
        $kyc->verified_at = now();
        $kyc->save();

        // Update the user's kyc_status based on admin decision
        $user = User::find($kyc->user_id);
        if ($request->status == 'Approved') {
            $user->kyc_status = 'Approved';
        } else {
            $user->kyc_status = 'Rejected';
        }
        $user->save();

        return redirect()->back()->with('success', 'KYC status updated successfully.');
    }

}
