<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Currency;

class CurrencyController extends Controller
{
    public function admincurrencyindex(Request $request)
    {
        
        $query = Currency::query();

        if ($request->has('search') && $request->search != '') {
            $query->where('currency', 'LIKE', '%' . $request->search . '%');
        }
    
        $currency = $query->paginate(30)->appends($request->query());

        return view('admin/currency', compact('currency'));
    }

    public function updateCurrencyStatus(Request $request)
    {
        // Validate the request
        $validated = $request->validate([
            'id' => 'required|exists:countries,id',  // Ensure the country ID exists
            'status' => 'required|boolean',  // Ensure the status is a boolean
        ]);
    
        // Find the country and update status
        $currency  = Currency::findOrFail($request->id);
        $currency ->status = $request->status;
        $currency ->save();
    
        return response()->json(['message' => 'Status updated successfully.']);
    }
}
