<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Country;

class CountryController extends Controller
{
    public function admincountryindex(Request $request)
    {

        $query = Country::query();

        if ($request->has('search') && $request->search != '') {
            $query->where('name', 'LIKE', '%' . $request->search . '%');
        }
    
        $country = $query->paginate(30)->appends($request->query());

        return view('admin/country', compact('country'));
    }

    public function updateCountryStatus(Request $request)
    {
        // Validate the request
        $validated = $request->validate([
            'id' => 'required|exists:countries,id',  // Ensure the country ID exists
            'status' => 'required|boolean',  // Ensure the status is a boolean
        ]);
    
        // Find the country and update status
        $country = Country::findOrFail($request->id);
        $country->status = $request->status;
        $country->save();
    
        return response()->json(['message' => 'Status updated successfully.']);
    }
    
    
}
