<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Transaction;
use App\Models\CheckDeposit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckDepositController extends Controller
{

    public function usercheckstore(Request $request)
    {
        // Validate the request
        $request->validate([
            'check_number' => 'required|string|max:255|regex:/^[\w\s\-]+$/',
            'bank_name' => 'required|string|max:255',
            'amount' => 'required|numeric|min:0.01|regex:/^[\w\s\-]+$/',
            'check_image' => 'required|image|mimes:jpeg,png,jpg|max:2048'
        ]);

        // Store the check deposit
        $checkDeposit = new CheckDeposit();
        $checkDeposit->user_id = Auth::id();
        $checkDeposit->check_number = $request->check_number;
        $checkDeposit->bank_name = $request->bank_name;
        $checkDeposit->amount = $request->amount;

        if ($request->hasFile('check_image')) {
            $file = $request->file('check_image');
            $filename = time() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('uploads/checks'), $filename);
            $checkDeposit->check_image = $filename;
        }

        $checkDeposit->save();

        return redirect('account/dashboard')->with('success', 'Check deposit submitted successfully! Pending approval.');
    }



    // Admin: View list of check deposits
    public function admindeposit()
    {
        $checkDeposits = CheckDeposit::all();
        return view('admin.deposit', compact('checkDeposits'));
    }

    // Admin approves or rejects a check deposit
    public function updateCheckDepositStatus(Request $request, $checkDepositId)
    {
        // Validate the request for status update
        $request->validate([
            'status' => 'required|in:Approved,Rejected',
        ]);
    
        // Find the check deposit by ID
        $checkDeposit = CheckDeposit::findOrFail($checkDepositId);
    
        // Update the status
        $checkDeposit->status = $request->status;
    
        // If the deposit is approved, add the amount to the user's balance
        if ($request->status == 'Approved') {
            // Find the user associated with the check deposit (assuming the check deposit has a user_id)
            $user = $checkDeposit->user;
    
            // Add the amount to the user's account balance
            $user->account_balance += $checkDeposit->amount;
    
            // Save the user's updated balance
            $user->save();
        }
    
        // Set approval details (for audit purposes)
        $checkDeposit->approved_at = now();
        $checkDeposit->approved_by = 1;  // Admin ID (assuming admin is user with ID 1)
    
        // Save the check deposit status change
        $checkDeposit->save();
    
        return redirect('admin/deposit')->with('success', 'Check deposit status updated successfully!');
    }
    
}
