<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ChatbotResponse;

class ChatbotResponseController extends Controller
{
    public function adminchatbotindex(Request $request) {
        
        $query = ChatbotResponse::query();

        if ($request->has('search') && $request->search != '') {
            $query->where('keyword', 'LIKE', '%' . $request->search . '%');
        }
    
        $responses = $query->paginate(25)->appends($request->query());

        return view('admin.chatbot.index', compact('responses'));
    }

    public function storechatbot(Request $request) {
        $request->validate([
            'keyword' => 'required|unique:chatbot_responses',
            'response' => 'required',
        ]);

        ChatbotResponse::create($request->all());

        return redirect()->route('admin.chatbot.index')->with('message', 'Response added successfully!');
    }

    public function adminchatbotedit($id) {
        $response = ChatbotResponse::findOrFail($id);
        return view('admin.chatbot.edit', compact('response'));
    }

    public function adminchatbotupdate(Request $request, $id) {
        $request->validate([
            'keyword' => 'required|unique:chatbot_responses,keyword,' . $id . ',id',
            'response' => 'required',
        ]);        

        //dd($request->all());

        $chatbot = ChatbotResponse::findOrFail($id);
        $chatbot->update($request->all());

        return redirect()->route('admin.chatbot.index')->with('message', 'Response updated successfully!');
    }

    public function adminchatbotdestroy(Request $request, $id) {
    
        $chatbot = ChatbotResponse::findOrFail($id);
        $chatbot->delete();
        return redirect()->route('admin.chatbot.index')->with('message', 'Response deleted successfully!');
    }
}
