<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ChatbotMessage;
use App\Models\ChatbotResponse;
use App\Models\Transaction;
use App\Models\WireTransfer;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class ChatbotController extends Controller
{

    public function sendMessage(Request $request)
    {
        $request->validate([
            'message' => 'required'
        ]);
    
        $user = Auth::user();
        $messageText = strtolower($request->message);
    
        $state = session('chatbot.state', null);
        $botReply = "Sorry, I don't understand your message.";
        $keywords = [];
        $currency = $user->acct_currency;
    
        // 1. Handle wire/domestic reference input
        if ($state === 'awaiting_wire_ref') {
            $transaction = DB::table('wire_transfers')
                ->where('transaction_reference', $request->message)
                ->where('user_id', $user->id)
                ->first();
        
            if ($transaction) {
                $botReply = "Here are your wire transaction details:\n";
                $botReply .= "Beneficiary Name: {$transaction->beneficiary_name}\n";
                $botReply .= "Beneficiary Bank: {$transaction->beneficiary_bank_name}\n";
                $botReply .= "Amount: $currency{$transaction->amount}\n";
                $botReply .= "Status: {$transaction->status}\n";
                $botReply .= "Reference: {$transaction->transaction_reference}\n";
                $botReply .= "Date: {$transaction->created_at}";
        
                if (strtolower($transaction->status) === 'pending') {
                    $botReply .= "\nNote: The transaction is expected to be completed within 7 days from the transfer date.";
                }
            } else {
                $botReply = "Sorry, no wire transaction found with that reference.";
            }
        
            session()->forget('chatbot.state');
        
        
    
        } elseif ($state === 'awaiting_domestic_ref') {
            $transaction = DB::table('transactions')->where('reference', $request->message)->where('user_id', $user->id)->first();
            if ($transaction) {
                $botReply = "Here are your domestic transaction details:\nAmount: {$transaction->amount}\nStatus: {$transaction->status}\nDate: {$transaction->created_at}";
            } else {
                $botReply = "Sorry, no domestic transaction found with that reference.";
            }
            session()->forget('chatbot.state');
    
        // 2. Handle clicked button options first
        } elseif ($messageText === 'wire transaction') {
            $botReply = "Please provide your wire transaction reference number.";
            session(['chatbot.state' => 'awaiting_wire_ref']);
    
        } elseif ($messageText === 'domestic transaction') {
            $botReply = "Please provide your domestic transaction reference number.";
            session(['chatbot.state' => 'awaiting_domestic_ref']);
    
        // 3. Then handle generic keywords like "transaction" or "payment"
        } elseif (str_contains($messageText, 'transaction') || str_contains($messageText, 'payment') || str_contains($messageText, 'issue')) {
            $botReply = "Is this about a wire transaction or a domestic transaction?";
            $keywords = ['Wire Transaction', 'Domestic Transaction'];
    
        // 4. Fallback to your ChatbotResponse table
        } else {
            $response = ChatbotResponse::whereRaw("LOWER(?) LIKE CONCAT('%', LOWER(keyword), '%')", [$messageText])->first();
            $botReply = $response ? $response->response : $botReply;
        }
    
        // Store messages
        ChatbotMessage::create([
            'user_id' => $user->id,
            'message' => $request->message,
            'response' => $botReply
        ]);
    
        $chatMessages = session('chatbot.messages', []);
        $chatMessages[] = ['type' => 'user', 'text' => $request->message];
        $chatMessages[] = ['type' => 'bot', 'text' => $botReply];
        session()->put('chatbot.messages', $chatMessages);
    
        return response()->json(['message' => $request->message, 'response' => $botReply, 'keywords' => $keywords]);
    }
    



    public function fetchMessages()
    {
        return response()->json(['messages' => session('chatbot.messages', [])]);
    }


    public function getKeywords()
    {
        $keywords = DB::table('chatbot_responses')->pluck('keyword');
        return response()->json(['keywords' => $keywords]);
    }



}
