<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Cards;
use Illuminate\Http\Request;
use App\Models\CardTransactionHistory;


class CardTransactionHistoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function admintransactioncards(Request $request)
    {
        $cards = CardTransactionHistory::latest()->paginate(20);
        return view('admin/transactions/cards', compact('cards'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function admintransactioncards_add(Request $request)
    {
        $cards = Cards::all();
        return view('admin/transactions/cards_add', compact('cards'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function admintransactioncardstore(Request $request)
    {
        $request->validate([
            'card_id' => 'required|exists:cards,id',
            'transaction_type' => 'required|in:credit,debit',
            'amount' => 'required|numeric|min:0',
            'description' => 'nullable|string',
            'status' => 'required|in:pending,success,failed', // 👈 Add this line
        ]);        
    
        $card = Cards::find($request->card_id);
    
        CardTransactionHistory::create([
            'card_id' => $card->id,
            'transaction_type' => $request->transaction_type,
            'amount' => $request->amount,
            'status' => $request->status,
            'description' => $request->description,
        ]);
    
        return redirect()->route('admin.transactions.cards')->with('success', 'Card Transaction recorded successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function admincardstransactionedit(Request $request, $id)
    {
        $cards = CardTransactionHistory::find($id);
        return view('admin.transactions.cards_edit', compact('cards'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function admincardstransactionupdate(Request $request, $id)
    {
        $cards = CardTransactionHistory::findOrFail($id);
        
        $cards->amount = $request->amount;
        $cards->transaction_type = $request->transaction_type;
        $cards->status = $request->status;
        $cards->description = $request->description;
        $cards->created_at = $request->created_at;

        $cards->save();
        return redirect()->route('admin.transactions.cards')->with('success', 'Card Transaction updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function admincardtransdestroy(CardTransactionHistory $cardTransactionHistory)
    {
        $cardTransactionHistory->delete();

        return redirect()->route('admin.transactions.cards')->with('success', 'Card transaction deleted successfully.');
    }
}
