<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use BotMan\BotMan\BotMan;
use BotMan\BotMan\Messages\Incoming\Answer;
use BotMan\BotMan\BotManFactory;
use BotMan\BotMan\Drivers\DriverManager;
use BotMan\Drivers\Web\WebDriver;
use App\BotMan\Conversations\OnboardingConversation;


class BotManController extends Controller
{
    public function handle()
    {
        DriverManager::loadDriver(WebDriver::class);

        $config = [];

        $botman = BotManFactory::create($config);

        $botman->hears('hi', function (BotMan $bot) {
            $bot->startConversation(new OnboardingConversation);
        });        

        $botman->listen();
    }
}
