<?php

namespace App\Http\Controllers;

use App\Models\AusBank;
use App\Models\CanBank;
use App\Models\UkBanks;
use App\Models\UsBanks;
use Illuminate\Http\Request;

class BanksController extends Controller
{
    public function adminbanksindex(Request $request)
    {
        $ausQuery = AusBank::query();
        if ($request->has('search') && $request->search != '') {
            $ausQuery->where('name', 'LIKE', '%' . $request->search . '%');
        }
        $ausBanks = $ausQuery->paginate(20, ['*'], 'aus')->appends($request->query());

        // For UK
        $ukQuery = UkBanks::query();
        if ($request->has('search') && $request->search != '') {
            $ukQuery->where('name', 'LIKE', '%' . $request->search . '%');
        }
        $ukBanks = $ukQuery->paginate(20, ['*'], 'uk')->appends($request->query());

        // For CAN
        $canQuery = CanBank::query();
        if ($request->has('search') && $request->search != '') {
            $canQuery->where('name', 'LIKE', '%' . $request->search . '%');
        }
        $canBanks = $canQuery->paginate(20, ['*'], 'can')->appends($request->query());

        // For US
        $usQuery = UsBanks::query();
        if ($request->has('search') && $request->search != '') {
            $usQuery->where('name', 'LIKE', '%' . $request->search . '%');
        }
        $usBanks = $usQuery->paginate(20, ['*'], 'us')->appends($request->query());

        return view('admin/banks', compact('ausBanks', 'ukBanks', 'canBanks', 'usBanks'));
    }


    public function updatebanksStatus(Request $request)
    {
        $bankType = $request->bank_type; // 'aus', 'uk', 'can', 'us'
        $id = $request->id;
        $status = $request->status;

        switch ($bankType) {
            case 'aus':
                $bank = \App\Models\AusBank::findOrFail($id);
                break;
            case 'uk':
                $bank = \App\Models\UkBanks::findOrFail($id);
                break;
            case 'can':
                $bank = \App\Models\CanBank::findOrFail($id);
                break;
            case 'us':
                $bank = \App\Models\UsBanks::findOrFail($id);
                break;
            default:
                return back()->with('error', 'Invalid bank type.');
        }

        $bank->status = $status;
        $bank->save();

        return response()->json(['message' => 'Status updated successfully.']);
    }


    public function adminaddusa(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'status' => 'nullable|boolean', // Optional, defaults to 0 if not sent
        ]);

        $save = new UsBanks;
        $save->name = $request->name;
        $save->status = $request->has('status') ? 1 : 0;

        $save->save();

        return redirect()->back()->with('success', 'United States Bank Added successfully.');
    }


    public function adminadduk(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'status' => 'nullable|boolean', // Optional, defaults to 0 if not sent
        ]);

        $save = new UkBanks;
        $save->name = $request->name;
        $save->status = $request->has('status') ? 1 : 0;

        $save->save();

        return redirect()->back()->with('success', 'United Kingdom Bank Added successfully.');
    }


    public function adminaddcan(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'status' => 'nullable|boolean', // Optional, defaults to 0 if not sent
        ]);

        $save = new CanBank;
        $save->name = $request->name;
        $save->status = $request->has('status') ? 1 : 0;

        $save->save();

        return redirect()->back()->with('success', 'Canadian Bank Added successfully.');
    }


    public function adminaddaus(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'status' => 'nullable|boolean', // Optional, defaults to 0 if not sent
        ]);

        $save = new AusBank;
        $save->name = $request->name;
        $save->status = $request->has('status') ? 1 : 0;

        $save->save();

        return redirect()->back()->with('success', 'Australian Bank Added successfully.');
    }

}
