<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Country;
use App\Models\Currency;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Illuminate\View\View;
use Illuminate\Support\Str;
use App\Mail\NewUserWelcomeMail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use App\Mail\WelcomeEmail;
use Illuminate\Foundation\Auth\RegistersUsers;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     */
    public function create(): View
    {
        $data['currency'] = Currency::all();
        $countries = Country::all();
        return view('auth.register', $data, compact('countries'));
    }

    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request)
    {
       //  dd($request->all());
        $validator = Validator::make($request->all(), [
            'firstname' => ['required', 'string', 'max:255', 'regex:/^[^<>]*$/'],
            'lastname' => ['required', 'string', 'max:255', 'regex:/^[^<>]*$/'],
            'username' => ['required', 'string', 'max:255', 'regex:/^[^<>]*$/'],
            'address' => ['required', 'string', 'max:500', 'regex:/^[^<>]*$/'],
            'acct_ssn' => ['required', 'string', 'max:255', 'regex:/^[^<>]*$/'],
            'email' => ['required', 'string', 'lowercase', 'email', 'max:255', 'unique:'.User::class, 'regex:/^[^<>]*$/'],
            'phone' => ['required', 'string', 'max:255', 'regex:/^[^<>]*$/'],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
            'g-recaptcha-response' => 'required',
            ], [
                'g-recaptcha-response.required' => 'Please verify that you are not a robot.',

        ]);

            // Check if validation fails
            if ($validator->fails()) {
                return response()->json([
                    'status' => 'error',
                    'errors' => $validator->errors()
                ], 422); // 422: Unprocessable Entity (used for validation errors)
            }

        // Check if validation fails
        //if ($validator->fails()) {
        //    return redirect()->back()->withErrors($validator)->withInput();
        //}

        $user = new User;
        $user->firstname = Trim ($request->firstname);
        $user->lastname = Trim ($request->lastname);
        $user->username = Trim ($request->username);
        $user->password = Hash::make($request->password);
        $user->email = Trim ($request->email);
        $user->dob = Trim ($request->dob);
        $user->gender = Trim ($request->gender);
        $user->account_type = Trim ($request->account_type);
        $user->acct_currency = Trim ($request->acct_currency);
        $user->account_balance = 0.00;
        $user->account_limit = 0.00;
        $user->loan_balance = 0.00;
        $user->acct_level = 'Primary';
        $user->phone = Trim ($request->phone);
        $user->country= Trim ($request->country);
        $user->state = Trim ($request->state);
        $user->city = Trim ($request->city);
        $user->address = Trim ($request->address);
        $user->acct_ssn = Trim ($request->acct_ssn);
        $user->acct_pin = '123456';
        $user->acct_otp = '123456';
        $user->role = 'user'; // Setting role to user
        $user->acct_status = 'Active'; // Setting acct_status to Active
        $user->kyc_status = 'Pending'; // Setting kyc_status to pending
        $user->remember_token   = Str::random(50);
        
        //if(!empty($request->file('photo'))){
                        
        //    $file = $request->file('photo');
        //    $randomStr = Str::random(30);
        //    $filename = $randomStr .'.'.$file->getClientOriginalExtension();
        //    $file->move('upload/', $filename);
        //    $user->photo = $filename;
       // }

        // Generating account number with '31' prefix and random 9 digits
        $user->account_no = '31' . mt_rand(100000000, 999999999);
        $user->save();

        event(new Registered($user));

        // Send welcome email 
        Mail::to($user->email)->send(new NewUserWelcomeMail($user));

        Auth::login($user);

        return redirect(route('account.dashboard', absolute: false));
    }
}
