<?php

namespace App\Http\Controllers;

use Hash;
use App\Models\User;
use App\Models\Country;
use App\Models\Currency;
use App\Models\NextOfKin;
use App\Models\Transaction;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Mail\NewUserWelcomeMail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Http\RedirectResponse;

class AdminController extends Controller
{
    public function admindashboard(Request $request)
    {
        $email = User::where('role', 'user')->get();
        $totalBalance = User::sum('account_balance');
        $userCount = User::where('role', 'user')->count();
        $wireCount = Transaction::where('transaction_type', 'Wire Transfer')->count();
        $transact = Transaction::latest()->take(6)->get();
        $domesticCount = Transaction::where('transaction_type', 'Domestic Transfer')->count();
        return view('admin.dashboard', compact('userCount', 'totalBalance', 'transact', 'email', 'wireCount', 'domesticCount'));
    }

    public function adminuserslist(Request $request)
    {
        $data['getRecord'] = User::where('role', 'user')->paginate(5)->appends(request()->query());
        return view('admin.users.list', $data);
    }

    public function adminusersnextlist(Request $request)
    {
        $next = NextOfKin::paginate(25);
        return view('admin/users/next', compact('next'));
    }

    public function adminusersnextadd(Request $request)
    {
        $user = User::where('role', 'user')->get();
        return view('admin/users/next_add', compact('user'));
    }

    public function adminusersnextupdate($id)
    {
        $nok = NextOfKin::findOrFail($id);      // $id is NextOfKin ID
        $user = $nok->user;                     // Retrieve related user via relationship
        $users = User::where('role', 'user')->get(); // All users for dropdown
        return view('admin.users.next_update', compact('nok', 'user', 'users'));
    }

    public function adminusersadd(Request $request)
    {
        $data['currency'] = Currency::where('status', true)->get();
        $data['countries'] = Country::where('status', true)->get();
        return view('admin.users.add', $data);
    }


    public function adminusersaddstore(Request $request)
    { // dd($request->all());

        $user = new User;
        $user->firstname = Trim($request->firstname);
        $user->lastname = Trim($request->lastname);
        $user->username = Trim($request->username);
        $user->password = Hash::make($request->password);
        $user->email = Trim($request->email);
        $user->dob = Trim($request->dob);
        $user->gender = Trim($request->gender);
        $user->account_type = Trim($request->account_type);
        $user->acct_currency = Trim($request->acct_currency);
        $user->account_balance = Trim($request->account_balance);
        $user->account_limit = Trim($request->account_limit);
        $user->loan_balance = Trim($request->loan_balance);
        $user->acct_level = Trim($request->acct_level);
        $user->phone = Trim($request->phone);
        $user->country = Trim($request->country);
        $user->state = Trim($request->state);
        $user->city = Trim($request->city);
        $user->address = Trim($request->address);
        $user->acct_ssn = Trim($request->acct_ssn);
        $user->role = Trim($request->role);
        $user->acct_status = Trim($request->acct_status);
        $user->remember_token   = Str::random(50);
        if (!empty($request->file('photo'))) {

            $file = $request->file('photo');
            $randomStr = Str::random(30);
            $filename = $randomStr . '.' . $file->getClientOriginalExtension();
            $file->move('upload/', $filename);
            $user->photo = $filename;
        }
        // Generating account number with '31' prefix and random 9 digits
        $user->account_no = '31' . mt_rand(100000000, 999999999);
        $user->save();

        // Send welcome email 
        Mail::to($user->email)->send(new NewUserWelcomeMail($user));

        return redirect('admin/users/list')->with('message', 'User Created successfully.');
    }

    public function adminusersedit(Request $request, $id)
    {
        $data['currency'] = Currency::all();
        $data['users'] = User::find($id);
        return view('admin.users.edit', $data);
    }

    public function adminuserseditupdate(Request $request, $id)
    {
        // dd($request->all());

        $user = User::find($id);
        $user->firstname = Trim($request->firstname);
        $user->lastname = Trim($request->lastname);
        $user->username = Trim($request->username);
        $user->email = Trim($request->email);
        $user->dob = Trim($request->dob);
        $user->gender = Trim($request->gender);
        $user->account_no = Trim($request->account_no);
        $user->account_type = Trim($request->account_type);
        $user->acct_currency = Trim($request->acct_currency);
        $user->account_balance = Trim($request->account_balance);
        $user->account_limit = Trim($request->account_limit);
        $user->loan_balance = Trim($request->loan_balance);
        $user->acct_level = Trim($request->acct_level);
        $user->acct_otp = Trim($request->acct_otp);
        $user->acct_pin = Trim($request->acct_pin);
        $user->phone = Trim($request->phone);
        $user->address = Trim($request->address);
        $user->acct_ssn = Trim($request->acct_ssn);
        $user->acct_status = Trim($request->acct_status);

        // Add OTP Enabled field
        $user->otp_enabled = $request->has('otp_enabled'); // Checkbox or toggle input handling

        if (!empty($request->file('photo'))) {

            $file = $request->file('photo');
            $randomStr = Str::random(30);
            $filename = $randomStr . '.' . $file->getClientOriginalExtension();
            $file->move('upload/', $filename);
            $user->photo = $filename;
        }

        if (!empty($request->password)) {
            $user->password = Hash::make($request->password);
        }
        $user->save();

        return redirect()->back()->with('message', 'Account Updated successfully.');
    }


    public function sessioindestroy(Request $request): RedirectResponse
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('admin/login')->with('message', 'Logout Successful');
    }

    public function adminprofile(Request $request)
    {
        return view('admin.profile');
    }


    public function adminprofileupdate(Request $request)
    {
        $user = request()->validate([
            'email' => 'required|unique:users,email,' . Auth::user()->id
        ]);

        $user = User::find(Auth::user()->id);
        $user->firstname     = trim($request->firstname);
        $user->lastname     = trim($request->lastname);
        $user->email    = trim($request->email);

        if (!empty($request->password)) {
            $user->password = Hash::make($request->password);
        }

        if (!empty($request->file('photo'))) {

            $file = $request->file('photo');
            $randomStr = Str::random(30);
            $filename = $randomStr . '.' . $file->getClientOriginalExtension();
            $file->move('upload/', $filename);
            $user->photo = $filename;
        }

        $user->save();

        return redirect()->back()->with('message', 'Profile Updated Successfully..');
    }

    public function adminuserdelete(Request $request, $id)
    {
        $request = User::find($id);
        $request->delete();
        return redirect()->back()->with('message', 'User Deleted Successfully');
    }
}
