<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AccessCodeController extends Controller
{
    public function access_code()
    {
        return view('access');
    }

    public function access_code_submit(Request $request)
    {
        $request->validate([
            'code' => 'required',
        ]);

        // Check if the provided access code exists in the users' referral code
        $codeExists = DB::table('website_settings')->where('reg_access', $request->code)->exists();

        if ($codeExists) {
            // Redirect to register with the code as a parameter
            return redirect()->route('register', ['access_code' => $request->code]);
        }

        return back()->withErrors(['code' => 'Invalid access code.']);
    }
}
