<?php

namespace App\Helpers;

use Illuminate\Support\Facades\DB;

class TransferHelper
{
    public static function getTotalTransfersForMonth($userId)
    {
        // Get the first and last day of the current month
        $startOfMonth = now()->startOfMonth();
        $endOfMonth = now()->endOfMonth();

        // Sum the total amount of wire transfers for the user in the current month
        $totalWireTransfers = DB::table('wire_transfers')
            ->where('user_id', $userId)
            ->where('status', 'Completed')
            ->whereBetween('created_at', [$startOfMonth, $endOfMonth])
            ->sum('amount');

        // Sum the total amount of local transfers for the user in the current month
        $totalLocalTransfers = DB::table('local_transfers')
            ->where('user_id', $userId)
            ->where('status', 'Completed')
            ->whereBetween('created_at', [$startOfMonth, $endOfMonth])
            ->sum('amount');

        // Return the combined total of wire and local transfers
        return $totalWireTransfers + $totalLocalTransfers;
    }
}
