<?php

namespace App\BotMan\Conversations;

use BotMan\BotMan\Messages\Conversations\Conversation;

class OnboardingConversation extends Conversation
{
    protected $name;
    protected $email;

    public function askName()
    {
        $this->ask('Hello from Telegram!', function ($answer) {
            $this->name = $answer->getText();
            $this->askEmail();
        });
    }

    public function askEmail()
    {
        $this->ask('What is your email address?', function ($answer) {
            $this->email = $answer->getText();
            $this->say("Thanks, {$this->name}. We've saved your email: {$this->email}");
        });
    }

    public function run()
    {
        $this->askName();
    }
}
