<script src="/user/assets/js/investment/investment-wallet.js"></script>


<script>
document.addEventListener('DOMContentLoaded', function () {
    const viewButtons = document.querySelectorAll('.view-details');

    viewButtons.forEach(button => {
        button.addEventListener('click', function () {
            const transactionId = this.getAttribute('data-id');

            fetch(`/transaction/${transactionId}`)
                .then(response => response.json())
                .then(data => {
                    // Ensure the modal elements are present
                    const modalBankName = document.getElementById('modal-bank-name');
                    const modalAccountNumber = document.getElementById('modal-account-number');
                    const modalAccountName = document.getElementById('modal-account-name');
                    const modalAmount = document.getElementById('modal-amount');
                    const modalTransactionType = document.getElementById('modal-transaction-type');
                    const modalTransactionDate = document.getElementById('modal-transaction-date');
                    const modalReference = document.getElementById('modal-reference');
                    const modalStatus = document.getElementById('modal-status');
                    const modalDescription = document.getElementById('modal-description');

                    if (modalBankName && modalAccountNumber && modalAmount && modalAccountName && modalTransactionType && modalTransactionDate && modalReference && modalStatus && modalDescription) {
                        // Populate the modal with transaction data
                        modalBankName.textContent = data.bank_name;
                        modalAccountNumber.textContent = data.account_number;
                        modalAccountName.textContent = data.account_name;
                        modalAmount.textContent = data.amount;
                        modalTransactionType.textContent = data.transaction_type;
                        modalTransactionDate.textContent = data.transaction_date;
                        modalReference.textContent = data.reference;
                        modalStatus.textContent = data.status;
                        modalDescription.textContent = data.description;

                        // Show the modal
                        const modal = new bootstrap.Modal(document.getElementById('transactionModal'));
                        modal.show();
                    } else {
                        console.error("One or more modal elements not found.");
                    }
                })
                .catch(error => {
                    alert('Error fetching transaction details: ' + error.message);
                });
        });
    });
});

</script>
