@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<!DOCTYPE html>
<html lang="en">
    <!-- HEADER -->
    @include('layouts.user.header')
    <body
        class="main-bg main-bg-opac main-bg-blur adminuiux-sidebar-fill-white adminuiux-sidebar-boxed theme-blue roundedui"
        data-theme="theme-blue"
        data-sidebarfill="adminuiux-sidebar-fill-white"
        data-bs-spy="scroll"
        data-bs-target="#list-example"
        data-bs-smooth-scroll="true"
        tabindex="0"
    ></body>
</html>

    @php
		$getfav = App\Models\WebsiteSettings::first();
	@endphp
<div class="pageloader">
    <div class="container h-100">
        <div class="row justify-content-center align-items-center text-center h-100">
            <div class="col-12 mb-auto pt-4"></div>
            <div class="col-auto">
                <img src="{{ url('upload/'.$getfav->website_favicon) }}" />
                <div class="loader10 mb-2 mx-auto"></div>
            </div>
            <div class="col-12 mt-auto pb-4"><p class="text-secondary">Please wait we are preparing awesome things to preview...</p></div>
        </div>
    </div>
</div>
<!-- NAVBAR -->
@include('layouts.user.navbar')
    
<div class="adminuiux-wrap">
    
<!-- NAVBAR -->
@include('layouts.user.sidebar')

    <main class="adminuiux-content has-sidebar" onclick="contentClick()">
        {{$slot}}
    </main>
</div>
<div class="modal adminuiux-modal fade" id="qrcodemodal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <div class="text-center my-4">
                    <figure class="avatar avatar-100 rounded-circle coverimg my-3">
                        @if(!empty(Auth::user()->photo))
                            <img src="{{ url('upload/', Auth::user()->photo) }}" alt="User-Profile">
                        @endif
                    </figure>
                </div>
                <div class="row">
                    <div class="col mb-3"><p class="text-secondary">Account Name</p></div>
                    <div class="col-auto mb-3"><p class="fw-medium">{{Auth::user()->firstname}} {{Auth::user()->lastname}}</p></div>
                </div>
                <div class="row">
                    <div class="col mb-3"><p class="text-secondary">Account Number</p></div>
                    <div class="col-auto mb-3"><p class="fw-medium">{{Auth::user()->account_no}}</p></div>
                </div>
                <div class="row">
                    <div class="col mb-3"><p class="text-secondary">Account Type</p></div>
                    <div class="col-auto mb-3"><p class="fw-medium">{{Auth::user()->account_type}}</p></div>
                </div>
                <div class="row">
                    <div class="col mb-3"><p class="text-secondary">Account Limit</p></div>
                    <div class="col-auto mb-3">
                        <p class="fw-medium">{{Auth::user()->acct_currency}}{{number_format(Auth::user()->account_limit, 2) }}</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer justify-content-between"><button type="button" class="btn btn-link theme-red" data-bs-dismiss="modal">Close</button></div>
        </div>
    </div>
</div>
<!-- FOOTER -->
@include('layouts.user.footer')

<!-- SCRIPT -->
@include('layouts.user.scripts')
