<x-adm>

    <div class="container-fluid">
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-lg-8">
                <div class="card profile-card card-bx m-b30">
                    <form action="{{ url('admin/users/edit/'. $users->id)}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="card-header">
                            <h4 class="card-title">Edit {{$users->firstname}} {{$users->lastname}}</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">First Name</label>
                                    <input type="text" name="firstname" class="form-control" value="{{$users->firstname}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Last Name</label>
                                    <input type="text" name="lastname" class="form-control" value="{{$users->lastname}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Username</label>
                                    <input type="text" name="username" class="form-control" value="{{$users->username}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Email</label>
                                    <input type="email" name="email" class="form-control" value="{{$users->email}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">DOB</label>
                                    <input type="date" name="dob" class="form-control" value="{{$users->dob}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Gender</label>
                                    <select class="default-select form-control" name="gender" id="validationCustom05">
                                        <option Value="{{$users->gender}}">{{$users->gender}}</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="card-header">
                            <h4 class="card-title">Account Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Account Number</label>
                                    <input type="number" name="account_no" class="form-control" value="{{$users->account_no}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Account Type</label>
                                    <select class="default-select form-control" name="account_type" id="validationCustom05">
                                        <option Value="{{$users->account_type}}">{{$users->account_type}}</option>
                                        <option value="Savings Account">Savings Account</option>
                                        <option value="Current Account">Current Account</option>
                                        <option value="Retirement Account">Retirement Account</option>
                                        <option value="Money Market Account (MMAs)">Money Market Account (MMAs)</option>
                                        <option value="Checking Account">Checking Account</option>
                                        <option value="Domiciliary Account">Domiciliary Account</option>
                                        <option value="Online Banking">Online Banking</option>
                                    </select>
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Account Currency</label>
                                    <select class="default-select form-control" name="acct_currency" id="validationCustom05">
                                        <option value="{{$users->acct_currency}}">{{$users->acct_currency}}</option>
                                        @foreach ($currency as $currency)
                                           <option value="{{$currency->symbol}}">{{$currency->currency}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Account Balance</label>
                                    <input type="number" name="account_balance" class="form-control" value="{{$users->account_balance}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Account Limit</label>
                                    <input type="number" name="account_limit" class="form-control" value="{{$users->account_limit}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Loan Balance</label>
                                    <input type="number" name="loan_balance" class="form-control" value="{{$users->loan_balance}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Account Level</label>
                                    <select class="default-select form-control" name="acct_level" id="validationCustom05">
                                        <option Value="{{$users->acct_level}}">{{$users->acct_level}}</option>
                                        <option value="Primary">Primary ($20,000 to $49,999.99)</option>
                                        <option value="Plus">Plus ($50,000 to $99,999.99)</option>
                                        <option value="Premium">Premium ($100,000 to $249,999.99)</option>
                                        <option value="Pinnacle">Pinnacle ($250,000+)</option>
                                    </select>
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Login Pin</label>
                                    <input type="number" name="acct_otp" class="form-control" value="{{$users->acct_otp}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Local Transfer Pin</label>
                                    <input type="number" name="acct_pin" class="form-control" value="{{$users->acct_pin}}">
                                </div>
                            </div>
                        </div>
                        <div class="card-header">
                            <h4 class="card-title">Contact Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Phone</label>
                                    <input type="phone" name="phone" class="form-control" value="{{$users->phone}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Address</label>
                                    <input type="text" name="address" class="form-control" value="{{$users->address}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">SSN</label>
                                    <input type="number" name="acct_ssn" class="form-control" value="{{$users->acct_ssn}}">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Account Status</label>
                                    <select class="default-select form-control" name="acct_status" id="validationCustom05">
                                        <option Value="{{$users->acct_status}}">{{$users->acct_status}}</option>
                                        <option value="Active">Active</option>
                                        <option value="Inactive">Inactive</option>
                                        <option value="Suspended">Suspended</option>
                                    </select>
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label for="formFileSm" class="form-label">Passport Image</label>
                                    <input class="form-control form-control-sm" name="photo" id="formFileSm" type="file">
                                </div>
                                <div class="col-sm-6 m-b30">
                                    <label class="form-label">Password</label>
                                    <input type="password" id="password" name="password" class="form-control" placeholder="Leave Empty if not changing" />
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary">UPDATE</button>
                                </div>
                            </div>
                            </div>
                            </div>
                        </div>
                        
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
$(document).ready(function () {
    $.ajax({
        url: '/get-countries',
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            $('#country').empty().append('<option value="{{$users->country}}">Select Country</option>');
            $.each(data, function (key, value) {
                // Set country.name as the value and keep country.id for fetching states
                $('#country').append('<option value="' + value.id + '" data-name="' + value.name + '">' + value.name + '</option>');
            });
        }
    });
});

    </script>

<script>
$('#country').change(function () {
    var countryId = $(this).val();
    var countryName = $(this).find(':selected').data('name');  // Get country name
    $('#selected_country_name').val(countryName);  // Save the name in a hidden field

    if (countryId) {
        $.ajax({
            url: '/get-states/' + countryId,
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                $('#state').empty().append('<option value="">Select State</option>');
                $.each(data, function (key, value) {
                    // Set state.name as the value
                    $('#state').append('<option value="' + value.id + '" data-name="' + value.name + '">' + value.name + '</option>');
                });
            }
        });
    } else {
        $('#state').empty().append('<option value="">Select State</option>');
    }
});

</script>
<script>
$('#state').change(function () {
    var stateId = $(this).val();
    var stateName = $(this).find(':selected').data('name');  // Get state name
    $('#selected_state_name').val(stateName);  // Save the name in a hidden field

    if (stateId) {
        $.ajax({
            url: '/get-cities/' + stateId,
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                $('#city').empty().append('<option value="">Select City</option>');
                $.each(data, function (key, value) {
                    // Set city.name as the value
                    $('#city').append('<option value="' + value.id + '" data-name="' + value.name + '">' + value.name + '</option>');
                });
            }
        });
    } else {
        $('#city').empty().append('<option value="">Select City</option>');
    }
});

$('#city').change(function () {
    var cityName = $(this).find(':selected').data('name');  // Get city name
    $('#selected_city_name').val(cityName);  // Save the name in a hidden field
});

</script>

</x-adm>