@php
    $getSetting = App\Models\WebsiteSettings::first();
@endphp

<div class="adminuiux-sidebar">
    <div class="adminuiux-sidebar-inner">
        <div class="px-3 not-iconic mt-2">
            <div class="row gx-3">
                <div class="col align-self-center"><h6 class="fw-medium">Main Menu</h6></div>
                <div class="col-auto">
                    <a class="btn btn-link btn-square" data-bs-toggle="collapse" data-bs-target="#usersidebarprofile" aria-expanded="false" role="button" aria-controls="usersidebarprofile"><i data-feather="user"></i></a>
                </div>
            </div>
            <div class="text-center collapse" id="usersidebarprofile">
                <figure class="avatar avatar-100 rounded-circle coverimg my-3">
                    @if(!empty(Auth::user()->photo))
                        <img src="{{ url('upload/', Auth::user()->photo) }}" alt="User-Profile">
                    @endif
                </figure>
                <h5 class="mb-1 fw-medium">{{Auth::user()->firstname}} {{Auth::user()->lastname}}</h5>
                <p class="small"><strong class="badge badge-light rounded-pill text-bg-theme-accent-1">{{Auth::user()->account_no}}</strong></p>
            </div>
            
        </div>
        <ul class="nav flex-column menu-active-line">
            <li class="nav-item">
                <a href="{{ url('account/dashboard')}}" class="nav-link"><i class="menu-icon bi bi-bank2"></i> <span class="menu-name">Dashboard</span></a>
            </li>
            <li class="nav-item">
                <a href="{{ url('account/loan')}}" class="nav-link"><i class="menu-icon bi bi-cash-coin"></i> <span class="menu-name">My Loans</span></a>
            </li>
            <li class="nav-item">
                <a href="{{ url('account/deposit')}}" class="nav-link"><i class="menu-icon bi bi-bullseye"></i> <span class="menu-name">Deposit</span></a>
            </li>
            <li class="nav-item dropdown">
                <a href="javascrit:void(0)" class="nav-link dropdown-toggle" data-bs-toggle="dropdown"><i class="menu-icon bi bi-piggy-bank"></i> <span class="menu-name">Send Money</span></a>
                <div class="dropdown-menu">
                    <div class="nav-item">
                        <a href="{{ url('account/local')}}" class="nav-link"><i class="menu-icon bi bi-bank"></i> <span class="menu-name">Local Transfer</span></a>
                    </div>
                    <div class="nav-item">
                        <a href="{{ url('account/intl')}}" class="nav-link"><i class="menu-icon bi bi-bank"></i> <span class="menu-name">Wire Transfer</span></a>
                    </div>
                </div>
            </li>
            <li class="nav-item">
                <a href="{{ url('account/transactions')}}" class="nav-link"><i class="menu-icon bi bi-cash-stack"></i> <span class="menu-name">Transactions</span></a>
            </li>
            <li class="nav-item">
                <a href="{{ url('account/cards')}}" class="nav-link"><i class="menu-icon bi bi-credit-card-fill"></i> <span class="menu-name">Cards</span></a>
            </li>
            <li class="nav-item">
                <a href="investment-personalization.html" class="nav-link"><i class="menu-icon bi bi-palette h4"></i> <span class="menu-name">Personalize ❤️</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="components.html"><i class="menu-icon bi bi-cpu"></i> <span class="menu-name">Components</span></a>
            </li>
        </ul>
        <div class="mt-auto"></div>
        <div class="px-3 mb-3 not-iconic">
            <h6 class="mb-3 fw-medium">Quick Links</h6>
            <div class="card adminuiux-card">
                <div class="card-body p-2">
                    <div class="row gx-2">
                        <div class="col-12 d-flex justify-content-between">
                            <a href="investment-search-mutual-funds.html" class="btn btn-square btn-link theme-red">
                                <span class="position-relative">
                                    <i data-feather="heart"></i> <span class="position-absolute top-0 start-100 translate-middle p-1 bg-success rounded-circle"><span class="visually-hidden">New alerts</span> </span>
                                </span>
                            </a>
                            <a href="investment-schedule.html" class="btn btn-square btn-link">
                                <span class="position-relative">
                                    <i data-feather="calendar"></i> <span class="position-absolute top-0 start-100 translate-middle p-1 bg-warning rounded-circle"><span class="visually-hidden">New alerts</span> </span>
                                </span>
                            </a>
                            <a href="investment-inbox.html" class="btn btn-square btn-link"><i data-feather="inbox"></i> </a>
                            <a href="investment-help-center.html" class="btn btn-square btn-link"><i data-feather="help-circle"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <ul class="nav flex-column menu-active-line">
            <li class="nav-item">
                <a href="investment-referral.html" class="nav-link"><i class="menu-icon" data-feather="users"></i> <span class="menu-name">Referral</span></a>
            </li>
            <li class="nav-item">
                <a href="investment-settings.html" class="nav-link"><i class="menu-icon" data-feather="settings"></i> <span class="menu-name">Settings</span></a>
            </li>
        </ul>
    </div>
</div>